# Annealing Bridges Offline and Online RL

## Installation

```bash
conda create -n soar python=3.10 -y
conda activate soar
pip install -r requirements.txt
```

For jax, install

```
pip install --upgrade "jax[cuda11_pip]==0.4.20" -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html
```

To use the D4RL envs, you would also need my fork of the d4rl envs below.
This fork incorporates the antmaze-ultra environments and fixes the kitchen environment rewards to be consistent between the offline dataset and the environment.

```
git clone git@github.com:zhouzypaul/D4RL.git
cd D4RL
pip install -e .
```

To use Mujoco, you would also need to install mujoco manually to `~/.mujoco/` (for more instructions on download see [here](https://github.com/openai/mujoco-py?tab=readme-ov-file#install-mujoco)), and use the following environment variables

```bash
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$HOME/.mujoco/mujoco210/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib/nvidia
```

To use the adroit envs, you would need

```
git clone --recursive https://github.com/nakamotoo/mj_envs.git
cd mj_envs
git submodule update --remote
pip install -e .
```

Download the adroit dataset from [here](https://drive.google.com/file/d/1yUdJnGgYit94X_AvV6JJP5Y3Lx2JF30Y/view) and unzip the files into `~/adroit_data/`.
If you would like to put the adroit datasets into another directory, use the environment variable `DATA_DIR_PREFIX` (checkout the code [here](https://github.com/zhouzypaul/wsrl/blob/4b5665987079934a926c10a09bd81bc3c48ea9fa/wsrl/envs/adroit_binary_dataset.py#L7) for more details).

```bash
export DATA_DIR_PREFIX=/path/to/your/data
```

## Running

The main run script is `finetune.py`. We provide bash scripts in `scripts` to train SOAR/PORL/WSRL/IQL/CQL/CalQL/SAC on the different environments.

The shared agent configs are in `configs/*`, and the environment-specific configs are in `configs/train_config.py` and in the bash scripts.

## Credits

This repo is built upon a version of Dibya Ghosh's [jaxrl_minimal](https://github.com/dibyaghosh/jaxrl_minimal) repository, which also included contributions from Kevin Black, Homer Walke, Kyle Stachowicz, and others.
